package com.androidbook.pettracker2;

import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteQueryBuilder;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.EditText;

import com.androidbook.pettracker2.PetTrackerDatabase.PetType;
import com.androidbook.pettracker2.PetTrackerDatabase.Pets;

public class PetTrackerEntryActivity extends PetTrackerActivity {
    /** Metoda wywoływana podczas pierwszego tworzenia aktywności. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.petentry);
	
		// Wypełnienie listy słów AutoComplete danymi z bazy 
		fillAutoCompleteFromDatabase();
	
		// Obsługa przycisku Zapisz
		final Button savePet = (Button) findViewById(R.id.ButtonSave);
		savePet.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

				final EditText petName = (EditText) findViewById(R.id.EditTextName);
				final EditText petType = (EditText) findViewById(R.id.EditTextSpecies);

				// Zapis nowych rekordów
				mDB.beginTransaction();
				try {

				 // Sprawdzenie czy gatunek już jest w bazie.
					long rowId = 0;
					String strPetType = petType.getText().toString()
							.toLowerCase();

					// Zapytanie SQL
					SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
					queryBuilder.setTables(PetType.PETTYPE_TABLE_NAME);
					queryBuilder.appendWhere(PetType.PET_TYPE_NAME + "='"
							+ strPetType + "'");

					// Wykonanie zapytania.
					Cursor c = queryBuilder.query(mDB, null, null, null, null,
							null, null);

					if (c.getCount() == 0) {
					 // Dodanie nowego gatunku do listy.
						ContentValues typeRecordToAdd = new ContentValues();
						typeRecordToAdd.put(PetType.PET_TYPE_NAME, strPetType);
						rowId = mDB.insert(PetType.PETTYPE_TABLE_NAME,
								PetType.PET_TYPE_NAME, typeRecordToAdd);
						
						// Aktualizacja automatycznie uzupełnianej listy gatunków.
						fillAutoCompleteFromDatabase();						
						
					} else {
						c.moveToFirst();
						rowId = c.getLong(c.getColumnIndex(PetType._ID));
					}

					c.close();

					// Zawsze dodajemy nowy rekord, nawet jeśli zwierzak o tym samym imieniu już istnieje.
					ContentValues petRecordToAdd = new ContentValues();
					petRecordToAdd.put(Pets.PET_NAME, petName.getText()
							.toString());
					petRecordToAdd.put(Pets.PET_TYPE_ID, rowId);
					mDB.insert(Pets.PETS_TABLE_NAME, Pets.PET_NAME,
							petRecordToAdd);

					mDB.setTransactionSuccessful();
				} finally {
					mDB.endTransaction();
				}

				// Przywrócenie formularza do stanu początkowego.
				petName.setText(null);
				petType.setText(null);
			}
		});

		// Obsługa przycisku Pokaż wszystkie zwierzaki.
		final Button gotoList = (Button) findViewById(R.id.ButtonShowPets);
		gotoList.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {

			 // Przejście do innej aktywności, która wyświetli listę zwierzaków.
				Intent intent = new Intent(PetTrackerEntryActivity.this, PetTrackerListActivity.class);
				startActivity(intent);
			}
		});

	}
	
	// Ta metoda jest podobna do tej z aplikacji PetTracker, jednak w tym przypadku to aktywność zarządza za nas kursorem.
	// To także nie jest idealny sposób kojarzenia dany z bazy SQLite z kontrolką AutoCompleteTextView.
	// Właściwe rozwiązanie zostało przedstawione w aplikacji MediaPetTracker.
	void fillAutoCompleteFromDatabase()
	{
		mCursor = mDB.query(PetType.PETTYPE_TABLE_NAME, new String[] {PetType.PET_TYPE_NAME, PetType._ID}, null, null,
				null, null, PetType.DEFAULT_SORT_ORDER);

		// Niech aktywność zarządza za nas kursorem, jesteśmy leniwi i nie chce się nam przesłaniać metod onPause itd.
		startManagingCursor(mCursor);
		
		// Rozwiązanie uproszczone i nieeleganckie, ta metoda nie korzysta z techniki kojarzenia danych, 
		// zamiast tego sami przeglądamy zawartość kursora i przygotowujemy obiekt ArrayAdapter.
		int iNumberOfSpeciesTypes = mCursor.getCount();
		String astrAutoTextOptions[] = new String[iNumberOfSpeciesTypes];
		if((iNumberOfSpeciesTypes > 0) && (mCursor.moveToFirst()))
		{
			for(int i = 0; i < iNumberOfSpeciesTypes; i++)
			{
				astrAutoTextOptions[i] = mCursor.getString(mCursor.getColumnIndex(PetType.PET_TYPE_NAME));
				mCursor.moveToNext();
			}

			ArrayAdapter<String> adapter =
		        new ArrayAdapter<String>(
		            this,
		            android.R.layout.simple_dropdown_item_1line,
		            astrAutoTextOptions);

			AutoCompleteTextView text = (AutoCompleteTextView) findViewById(R.id.EditTextSpecies);
			text.setAdapter(adapter);
		}
		
	}
	
}